function values = extract_cds_values(CDX, fieldname, date, sub_cell_field)
% --------------------------------------------------------------------------------------------------
% For a given date and given fieldname, extract all values of the individual credit default swaps on
% that date. Use NaNs for non-available data.
% --------------------------------------------------------------------------------------------------
% CDX               ... credit index structure
% fieldname         ... name of field of interest
% date              ... values for which field to extract
% sub_cell_field    ... optional sub-field
% --------------------------------------------------------------------------------------------------
% sample call: extract_cds_values(CDX_NA_IG2, 'intensity_P', datenum('12/05/2005'));
%              extract_cds_values(CDX_NA_IG2, 'market_price', datenum('12/05/2005'), 1);
% --------------------------------------------------------------------------------------------------

values = NaN(length(CDX.portfolio), 1);
for i=1:length(CDX.portfolio)
    % Extract lambda_P for i-th CDS
    cds = CDX.portfolio(i);
    if (~isfield(cds, fieldname))
        continue;
    end
    if isempty(cds.(fieldname))
        continue;
    end
    date_pos_cds = find(cds.dates{1} == date);
    if isempty(date_pos_cds)
        continue;
    end
    if (nargin <= 3)
        values(i) = cds.(fieldname)(date_pos_cds,:);
    else
        values(i) = cds.(fieldname){sub_cell_field}(date_pos_cds,:);
    end
end
